/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.circles;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.circles.ICircleComponent;
import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.misc.Result;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.utils.HexUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class CircleExecutionState {
    public static final String TAG_IMPETUS_POS = "impetus_pos";
    public static final String TAG_IMPETUS_DIR = "impetus_dir";
    public static final String TAG_KNOWN_POSITIONS = "known_positions";
    public static final String TAG_REACHED_POSITIONS = "reached_positions";
    public static final String TAG_CURRENT_POS = "current_pos";
    public static final String TAG_ENTERED_FROM = "entered_from";
    public static final String TAG_IMAGE = "image";
    public static final String TAG_CASTER = "caster";
    public static final String TAG_PIGMENT = "pigment";
    public final class_2338 impetusPos;
    public final class_2350 impetusDir;
    public final Set<class_2338> knownPositions;
    public final List<class_2338> reachedPositions;
    public class_2338 currentPos;
    public class_2350 enteredFrom;
    public CastingImage currentImage;
    @Nullable
    public UUID caster;
    @Nullable
    public FrozenPigment casterPigment;
    public final class_238 bounds;

    protected CircleExecutionState(class_2338 impetusPos, class_2350 impetusDir, Set<class_2338> knownPositions, List<class_2338> reachedPositions, class_2338 currentPos, class_2350 enteredFrom, CastingImage currentImage, @Nullable UUID caster, @Nullable FrozenPigment casterPigment) {
        this.impetusPos = impetusPos;
        this.impetusDir = impetusDir;
        this.knownPositions = knownPositions;
        this.reachedPositions = reachedPositions;
        this.currentPos = currentPos;
        this.enteredFrom = enteredFrom;
        this.currentImage = currentImage;
        this.caster = caster;
        this.casterPigment = casterPigment;
        this.bounds = BlockEntityAbstractImpetus.getBounds(new ArrayList<class_2338>(this.knownPositions));
    }

    @Nullable
    public class_3222 getCaster(class_3218 world) {
        if (this.caster == null) {
            return null;
        }
        class_1297 entity = world.method_14190(this.caster);
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            return serverPlayer;
        }
        return null;
    }

    public static Result<CircleExecutionState, @Nullable class_2338> createNew(BlockEntityAbstractImpetus impetus, @Nullable class_3222 caster) {
        UUID casterUUID;
        class_3218 level = (class_3218)impetus.method_10997();
        if (level == null) {
            return new Result.Err(null);
        }
        Stack<Pair> todo = new Stack<Pair>();
        todo.add(Pair.of((Object)impetus.getStartDirection(), (Object)impetus.method_11016().method_10093(impetus.getStartDirection())));
        HashSet<class_2338> seenGoodPosSet = new HashSet<class_2338>();
        ArrayList<class_2338> seenGoodPositions = new ArrayList<class_2338>();
        while (!todo.isEmpty()) {
            ICircleComponent cmp;
            Pair pair = (Pair)todo.pop();
            class_2350 enterDir = (class_2350)pair.getFirst();
            class_2338 herePos = (class_2338)pair.getSecond();
            class_2680 hereBs = level.method_8320(herePos);
            class_2248 class_22482 = hereBs.method_26204();
            if (!(class_22482 instanceof ICircleComponent) || !(cmp = (ICircleComponent)class_22482).canEnterFromDirection(enterDir, herePos, hereBs, level)) continue;
            if (seenGoodPosSet.add(herePos)) {
                seenGoodPositions.add(herePos);
                EnumSet<class_2350> outs = cmp.possibleExitDirections(herePos, hereBs, (class_1937)level);
                for (class_2350 out : outs) {
                    todo.add(Pair.of((Object)out, (Object)herePos.method_10093(out)));
                }
            }
            if (seenGoodPosSet.size() < HexConfig.server().maxSpellCircleLength()) continue;
            return new Result.Err(null);
        }
        if (seenGoodPositions.isEmpty()) {
            return new Result.Err(null);
        }
        if (!seenGoodPosSet.contains(impetus.method_11016())) {
            return new Result.Err<CircleExecutionState, class_2338>((class_2338)seenGoodPositions.get(seenGoodPositions.size() - 1));
        }
        HashSet<class_2338> knownPositions = new HashSet<class_2338>(seenGoodPositions);
        ArrayList<class_2338> reachedPositions = new ArrayList<class_2338>();
        reachedPositions.add(impetus.method_11016());
        class_2338 start = (class_2338)seenGoodPositions.get(0);
        FrozenPigment colorizer = null;
        if (caster == null) {
            casterUUID = null;
        } else {
            colorizer = HexAPI.instance().getColorizer((class_1657)caster);
            casterUUID = caster.method_5667();
        }
        return new Result.Ok<CircleExecutionState, class_2338>(new CircleExecutionState(impetus.method_11016(), impetus.getStartDirection(), knownPositions, reachedPositions, start, impetus.getStartDirection(), new CastingImage(), casterUUID, colorizer));
    }

    public class_2487 save() {
        class_2487 out = new class_2487();
        out.method_10566(TAG_IMPETUS_POS, (class_2520)class_2512.method_10692((class_2338)this.impetusPos));
        out.method_10567(TAG_IMPETUS_DIR, (byte)this.impetusDir.ordinal());
        class_2499 knownTag = new class_2499();
        for (class_2338 bp : this.knownPositions) {
            knownTag.add((Object)class_2512.method_10692((class_2338)bp));
        }
        out.method_10566(TAG_KNOWN_POSITIONS, (class_2520)knownTag);
        class_2499 reachedTag = new class_2499();
        for (class_2338 bp : this.reachedPositions) {
            reachedTag.add((Object)class_2512.method_10692((class_2338)bp));
        }
        out.method_10566(TAG_REACHED_POSITIONS, (class_2520)reachedTag);
        out.method_10566(TAG_CURRENT_POS, (class_2520)class_2512.method_10692((class_2338)this.currentPos));
        out.method_10567(TAG_ENTERED_FROM, (byte)this.enteredFrom.ordinal());
        out.method_10566(TAG_IMAGE, (class_2520)this.currentImage.serializeToNbt());
        if (this.caster != null) {
            out.method_25927(TAG_CASTER, this.caster);
        }
        if (this.casterPigment != null) {
            out.method_10566(TAG_PIGMENT, (class_2520)this.casterPigment.serializeToNBT());
        }
        return out;
    }

    public static CircleExecutionState load(class_2487 nbt, class_3218 world) {
        class_2338 startPos = class_2512.method_10691((class_2487)nbt.method_10562(TAG_IMPETUS_POS));
        class_2350 startDir = class_2350.values()[nbt.method_10571(TAG_IMPETUS_DIR)];
        HashSet<class_2338> knownPositions = new HashSet<class_2338>();
        class_2499 knownTag = nbt.method_10554(TAG_KNOWN_POSITIONS, 10);
        for (class_2520 tag : knownTag) {
            knownPositions.add(class_2512.method_10691((class_2487)((class_2487)HexUtils.downcast(tag, class_2487.field_21029))));
        }
        ArrayList<class_2338> reachedPositions = new ArrayList<class_2338>();
        class_2499 reachedTag = nbt.method_10554(TAG_REACHED_POSITIONS, 10);
        for (class_2520 tag : reachedTag) {
            reachedPositions.add(class_2512.method_10691((class_2487)((class_2487)HexUtils.downcast(tag, class_2487.field_21029))));
        }
        class_2338 currentPos = class_2512.method_10691((class_2487)nbt.method_10562(TAG_CURRENT_POS));
        class_2350 enteredFrom = class_2350.values()[nbt.method_10571(TAG_ENTERED_FROM)];
        CastingImage image = CastingImage.loadFromNbt(nbt.method_10562(TAG_IMAGE), world);
        UUID caster = null;
        if (nbt.method_25928(TAG_CASTER)) {
            caster = nbt.method_25926(TAG_CASTER);
        }
        FrozenPigment pigment = null;
        if (nbt.method_10573(TAG_PIGMENT, 10)) {
            pigment = FrozenPigment.fromNBT(nbt.method_10562(TAG_PIGMENT));
        }
        return new CircleExecutionState(startPos, startDir, knownPositions, reachedPositions, currentPos, enteredFrom, image, caster, pigment);
    }

    public boolean tick(BlockEntityAbstractImpetus impetus) {
        class_3218 world = (class_3218)impetus.method_10997();
        if (world == null) {
            return true;
        }
        CircleCastEnv env = new CircleCastEnv(world, this);
        class_2680 executorBlockState = world.method_8320(this.currentPos);
        class_2248 class_22482 = executorBlockState.method_26204();
        if (!(class_22482 instanceof ICircleComponent)) {
            ICircleComponent.sfx(this.currentPos, executorBlockState, (class_1937)world, Objects.requireNonNull(env.getImpetus()), false);
            return false;
        }
        ICircleComponent executor = (ICircleComponent)class_22482;
        executorBlockState = executor.startEnergized(this.currentPos, executorBlockState, (class_1937)world);
        this.reachedPositions.add(this.currentPos);
        boolean halt = false;
        ICircleComponent.ControlFlow ctrl = executor.acceptControlFlow(this.currentImage, env, this.enteredFrom, this.currentPos, executorBlockState, world);
        if (env.getImpetus() == null) {
            return false;
        }
        if (ctrl instanceof ICircleComponent.ControlFlow.Stop) {
            halt = true;
        } else if (ctrl instanceof ICircleComponent.ControlFlow.Continue) {
            ICircleComponent.ControlFlow.Continue cont = (ICircleComponent.ControlFlow.Continue)ctrl;
            Pair<class_2338, class_2350> found = null;
            for (Pair<class_2338, class_2350> exit : cont.exits) {
                ICircleComponent cc;
                class_2680 there = world.method_8320((class_2338)exit.getFirst());
                class_2248 class_22483 = there.method_26204();
                if (!(class_22483 instanceof ICircleComponent) || !(cc = (ICircleComponent)class_22483).canEnterFromDirection((class_2350)exit.getSecond(), (class_2338)exit.getFirst(), there, world)) continue;
                if (found != null) {
                    impetus.postDisplay((class_2561)class_2561.method_43469((String)"hexcasting.tooltip.circle.many_exits", (Object[])new Object[]{class_2561.method_43470((String)this.currentPos.method_23854()).method_27692(class_124.field_1061)}), new class_1799((class_1935)class_1802.field_8251));
                    ICircleComponent.sfx(this.currentPos, executorBlockState, (class_1937)world, Objects.requireNonNull(env.getImpetus()), false);
                    halt = true;
                    break;
                }
                found = exit;
            }
            if (found == null) {
                ICircleComponent.sfx(this.currentPos, executorBlockState, (class_1937)world, Objects.requireNonNull(env.getImpetus()), false);
                impetus.postNoExits(this.currentPos);
                halt = true;
            } else {
                ICircleComponent.sfx(this.currentPos, executorBlockState, (class_1937)world, Objects.requireNonNull(env.getImpetus()), true);
                this.currentPos = (class_2338)found.getFirst();
                this.enteredFrom = (class_2350)found.getSecond();
                this.currentImage = cont.update.withOverriddenUsedOps(0L);
            }
        }
        return !halt;
    }

    protected int getTickSpeed() {
        return Math.max(2, 10 - (this.reachedPositions.size() - 1) / 3);
    }

    public void endExecution(BlockEntityAbstractImpetus impetus) {
        class_3218 world = (class_3218)impetus.method_10997();
        if (world == null) {
            return;
        }
        for (class_2338 pos : this.reachedPositions) {
            class_2680 there = world.method_8320(pos);
            class_2248 class_22482 = there.method_26204();
            if (!(class_22482 instanceof ICircleComponent)) continue;
            ICircleComponent cc = (ICircleComponent)class_22482;
            cc.endEnergized(pos, there, (class_1937)world);
        }
    }
}

